/*
 *
 *   BaseZ
 *
 *   Copyright (C) 2013, 2016  Milan Kupcevic
 *
 *   You can redistribute and/or modify this software under the
 *   terms of the GNU General Public License version 3, or any later
 *   version as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   GPLv3+
 *
 *
 *   Encodings per RFC 4648:
 *    base64     Base 64 Encoding
 *    base64url  Base 64 Encoding with URL and Filename Safe Alphabet
 *    base32     Base 32 Encoding
 *    base32hex  Base 32 Encoding with Extended Hex Alphabet
 *    base16     Base 16 Encoding
 *
 */

#ifndef BASEZ_H
#define BASEZ_H

#include <stddef.h>

void
encode_base16u (
  const unsigned char  *byte_in,
  unsigned char *buffer_out);      /* 2 bytes */

void
encode_base16l (
  const unsigned char  *byte_in,
  unsigned char *buffer_out);      /* 2 bytes */

int /* 1 - OK; 0 - invalid input */
decode_base16(
  const unsigned char *buffer_in,  /* 2 bytes        */
  unsigned char *buffer_out);      /* a decoded byte */

void
encode_base32u(
  const unsigned char *buffer_in,  /* 5 bytes       */
  const int bytes_to_encode,       /* >= 1 and <= 5 */
  unsigned char *buffer_out);      /* 8 bytes       */

void
encode_base32l(
  const unsigned char *buffer_in,  /* 5 bytes       */
  const int bytes_to_encode,       /* >= 1 and <= 5 */
  unsigned char *buffer_out);      /* 8 bytes       */

int /* 0 - invalid input; >= 1 and <= 5 - number of decoded bytes */
decode_base32(
  const unsigned char *buffer_in,  /* 8 bytes       */
  unsigned char *buffer_out);      /* 5 bytes       */

void
encode_base32hexu(
  const unsigned char *buffer_in,  /* 5 bytes       */
  const int bytes_to_encode,       /* >= 1 and <= 5 */
  unsigned char *buffer_out);      /* 8 bytes       */

void
encode_base32hexl(
  const unsigned char *buffer_in,  /* 5 bytes       */
  const int bytes_to_encode,       /* >= 1 and <= 5 */
  unsigned char *buffer_out);      /* 8 bytes       */

int /* 0 - invalid input; >= 1 and <= 5 - number of decoded bytes */
decode_base32hex(
  const unsigned char *buffer_in,  /* 8 bytes       */
  unsigned char *buffer_out);      /* 5 bytes       */

void
encode_base64(
  const unsigned char *buffer_in,  /* 3 bytes       */
  const int bytes_to_encode,       /* >= 1 and <= 3 */
  unsigned char *buffer_out);      /* 4 bytes       */

int /* 0 - invalid input; >= 1 and <= 3 - number of decoded bytes */
decode_base64(
  const unsigned char *buffer_in,  /* 4 bytes       */
  unsigned char *buffer_out);      /* 3 bytes       */

void
encode_base64url(
  const unsigned char *buffer_in,  /* 3 bytes       */
  const int bytes_to_encode,       /* >= 1 and <= 3 */
  unsigned char *buffer_out);      /* 4 bytes       */

int /* 0 - invalid input; >= 1 and <= 3 - number of decoded bytes */
decode_base64url(
  const unsigned char *buffer_in,  /* 4 bytes       */
  unsigned char *buffer_out);      /* 3 bytes       */

#endif
